/******************** (C) COPYRIGHT 2006 STMicroelectronics ********************
* File Name          : main.c
* Author             : MCD Application Team
* Date First Issued  : 10/25/2004
* Description        : The main program
********************************************************************************
* History:
*  09/15/2006 : IAP Version 3.0
*  02/01/2006 : IAP Version 2.0
*  11/24/2004 : IAP Version 1.0
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

/* Includes ------------------------------------------------------------------*/
#include "common.h"
/* Private macro ---------------------------------------------------------------*/
/* Private variables -----------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
static u8 Push_Button_Read (void);
static void Push_Button_Config(void);

/* Private functions ---------------------------------------------------------*/
/*******************************************************************************
* Function Name  : IAP_Init
* Description    : Initialize the IAP(Configure PLL, UART and GPIOs).
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void IAP_Init(void)
{
  CMU_InitTypeDef CMU_InitStructure;
  GPIO_InitTypeDef GPIO_InitStructure;
  UART_InitTypeDef UART_InitStructure;
  PRCCU_InitTypeDef PRCCU_InitStructure;


  /* Configure CMU and switch to the external 8MHz Quartz */
  CMU_StructInit(&CMU_InitStructure);
  CMU_InitStructure.CMU_CKSEL0 = CMU_CKSEL0_CKOSC;
  CMU_Init (&CMU_InitStructure);

  /* PRCCU Config */
  PRCCU_InitStructure.PRCCU_DIV2 = ENABLE;
  PRCCU_InitStructure.PRCCU_MCLKSRC_SRC = PRCCU_MCLKSRC_PLL;
  PRCCU_InitStructure.PRCCU_PLLDIV = PRCCU_PLLDIV_4 ;
  PRCCU_InitStructure.PRCCU_PLLMUL = PRCCU_PLLMUL_16;
  PRCCU_InitStructure.PRCCU_FREEN = DISABLE;
  PRCCU_Init(&PRCCU_InitStructure);

  /*Enable Clock for UART0*/
  CFG_PeripheralClockConfig(CFG_CLK_UART0 , ENABLE);
  /*Enable Clock for GPIO6*/
  CFG_PeripheralClockConfig(CFG_CLK_GPIO6 , ENABLE);

  /* UART0_Tx_Pin configuration*/
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF_PP;
  GPIO_InitStructure.GPIO_Pins = GPIO_PIN_9;
  GPIO_Init(GPIO6, &GPIO_InitStructure);
  /* UART0_Rx_Pin configuration */
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IN_TRI_TTL;
  GPIO_InitStructure.GPIO_Pins = GPIO_PIN_8 ;
  GPIO_Init(GPIO6, &GPIO_InitStructure);

  /* UART0 configured as follow:
        - Baudrate = 115200Bps
        - No parity 
        - 8 data bits 
        - 1 stop bit  
  */
  /* Initialize Structure with default values */
  UART_StructInit(&UART_InitStructure);

  UART_InitStructure.UART_BaudRate  = 115200;
  UART_InitStructure.UART_Mode = UART_Mode_8D ;
  UART_InitStructure.UART_Loop_Standard = UART_Standard;
  UART_InitStructure.UART_StopBits = UART_StopBits_1;
  UART_InitStructure.UART_FIFO = UART_FIFO_Disable;
  UART_InitStructure.UART_Rx = UART_Rx_Enable;
  UART_Init(UART0, &UART_InitStructure);

  UART_Cmd(UART0, ENABLE);

}

/*******************************************************************************
* Function Name  : Push_Button_Read
* Description    : Read the port pin (connected to the push button) level.
* Input          : None
* Output         : None
* Return         : The port pin level (SET or RESET).
*******************************************************************************/
static u8 Push_Button_Read (void)
{
  /* Return the status of the P5.10 pin = "SEL" button on the STR730-EVAL */
  return GPIO_BitRead(GPIO5, GPIO_PIN_10);

}

/*******************************************************************************
* Function Name  : Push_Button_Config
* Description    : Configures the port pin connected to the push button.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
static void Push_Button_Config(void)
{
  GPIO_InitTypeDef  GPIO_InitStructure;

  /*Enable Clock for GPIO5*/
  CFG_PeripheralClockConfig(CFG_CLK_GPIO5 , ENABLE);
  /*Configure GPIO5 pin 10*/
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IN_TRI_TTL;
  GPIO_InitStructure.GPIO_Pins = GPIO_PIN_10 ;
  GPIO_Init (GPIO5, &GPIO_InitStructure);
}

/*******************************************************************************
* Function Name  : main
* Description    : Main program.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void main(void)
{
  pFunction Jump_To_Application;

#ifdef DEBUG
  debug();
#endif

  Push_Button_Config();

  if (Push_Button_Read())          /* If SEL is pressed */

  {
    /* Execute the IAP driver in order to re-program the Flash */
    IAP_Init();
    SerialPutString("\r\n======================================================================");
    SerialPutString("\r\n=              (C) Copyright 2006 STMicroelecronics                  =");
    SerialPutString("\r\n=                                                                    =");
    SerialPutString("\r\n=     In-Application Programming Application  (Version 3.0)          =");
    SerialPutString("\r\n=                                                                    =");
    SerialPutString("\r\n=                                   By MCD Application Team          =");
    SerialPutString("\r\n======================================================================");
    SerialPutString("\r\n\r\n");
    Main_Menu ();
  }

  else /* Keep the user application running */
  {

    Jump_To_Application = (pFunction) ApplicationAddress;
    Jump_To_Application();
  }

  while (1);

}
/*******************(C)COPYRIGHT 2006 STMicroelectronics *****END OF FILE****/
